#include <iostream>
#include <math.h>
using namespace std;

long long getDigits(long long n) {
    long long s = 0;
    long long m = n;
    while (m > 0) {
        s += m % 10;
        m /= 10;
    }

    return s;
}

bool isSmith(long long n) {
    if (n == 2) return false;

    long long a = getDigits(n);
    long long b = 0;
    long long m = n;

    while (m % 2 == 0) {
        m /= 2;
        b += 2;
    }

    long long s = sqrt(m) + 1;
    for (long long i = 3; i < s; i+=2) {
        while (m % i == 0) {
            m /= i;
            b += i;
        }

        if (i > m) break;
    }

    if (m == n) return false;
    if (m > 1) b += getDigits(m);
    return (a == b);
}

long long getFirstSmith(long long n) {
    for (long long i = n + 1; ; i+=1) {
        if (isSmith(i)) return i;
    }
}

int main() {
    long long n;
    cin >> n;

    for (long long i = 0; i < n; i++) {
        long long s;
        cin >> s;
        cout << getFirstSmith(s);

        if (i < n-1) cout << " ";
    }
}
